* This file generates pre-1994 want job and discouraged series from the CPS microdata.
* The rest of the data for Figure 7 are public BLS data.

local inpath "/mcr/cps/basic_new/data/stata"
set more off

local x=197601
while `x' <=199312{

clear
display `x'

gzuse "`inpath'/cpsb`x'.dta.gz"

keep hrmis pedwwnto adwhynl1 pemlr peage pwsswgt  

gen date=`x'

if `x' >= 197602 {
    append using "Fig7.dta"
    }
save "Fig7.dta", replace

local x = `x' + 1
if (`x'-13)/100 == int((`x'-13)/100) {
    local x = `x' + 88
    }
}


keep if peage>=16

* Labor market status
gen     mlr =1 if (pemlr==1 | pemlr ==2)
replace mlr =2 if (pemlr==3 & date<=198812)
replace mlr =2 if (pemlr==3 | pemlr==4) & date>198812
replace mlr =3 if pemlr>4
replace mlr =3 if (pemlr==4 & date<=198812)


* NLF Want Job: before 1994, only ORG were asked about WJ
preserve

keep if hrmis==4 | hrmis==8
replace mlr =4 if mlr==3 & (pedwwnto==1 | pedwwnto==2) & date<199401

collapse (sum) pwsswgt, by(date mlr)
drop if mlr==.
gen wgt=pwsswgt/1000
drop pwsswgt
reshape wide wgt, i(date) j(mlr)

gen wj_org = wgt4/(wgt1+wgt2+wgt3+wgt4)
drop wgt*

export excel using fig7.xlsx, sheet("wj1976to1994ORG") sheetreplace firstrow(variables)  
restore
*

* NLF Discouraged: before 1994, only ORG were asked about disc
preserve

keep if hrmis==4 | hrmis==8
replace mlr =4 if mlr==3 & adwhynl1 ==1

collapse (sum) pwsswgt, by(date mlr)
drop if mlr==.
gen wgt=pwsswgt/1000
drop pwsswgt
reshape wide wgt, i(date) j(mlr)

gen disc_org = wgt4/(wgt1+wgt2+wgt3+wgt4)
drop wgt*

export excel using fig7.xlsx, sheet("disc1976to1994ORG") sheetreplace firstrow(variables)  
restore
*
